/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.demonmobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupDemon;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackRanged;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.entity.navigate.ArenaNode;
import com.lycanitesmobs.core.entity.navigate.ArenaNodeNetwork;
import com.lycanitesmobs.core.entity.navigate.ArenaNodeNetworkGrid;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.demonmobs.entity.EntityAstaroth;
import com.lycanitesmobs.demonmobs.entity.EntityCacodemon;
import com.lycanitesmobs.demonmobs.entity.EntityDevilGatling;
import com.lycanitesmobs.demonmobs.entity.EntityDevilstar;
import com.lycanitesmobs.demonmobs.entity.EntityNetherSoul;
import com.lycanitesmobs.demonmobs.entity.EntityTrite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAsmodeus
extends EntityCreatureBase
implements IMob,
IGroupDemon {
    protected static final DataParameter<Byte> ANIMATION_STATES = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187191_a);
    public EntityAIAttackRanged aiRangedAttack;
    public List<EntityPlayer> playerTargets = new ArrayList<EntityPlayer>();
    public boolean firstPlayerTargetCheck = false;
    public List<EntityTrite> triteMinions = new ArrayList<EntityTrite>();
    public List<EntityAstaroth> astarothMinions = new ArrayList<EntityAstaroth>();
    public List<EntityCacodemon> cacodemonMinions = new ArrayList<EntityCacodemon>();
    public int devilstarStreamTime = 0;
    public int devilstarStreamTimeMax = 100;
    public int devilstarStreamCharge = 400;
    public int devilstarStreamChargeMax = 400;
    public int hellshieldAstarothRespawnTime = 0;
    public int hellshieldAstarothRespawnTimeMax = 30;
    public int rebuildAstarothRespawnTime = 0;
    public int rebuildAstarothRespawnTimeMax = 40;
    public float damageTakenThisSec = 0.0f;
    public float healthLastTick = -1.0f;
    public ArenaNodeNetwork arenaNodeNetwork;
    public ArenaNode currentArenaNode;
    public int arenaNodeChangeCooldown = 0;
    public int arenaNodeChangeCooldownMax = 200;
    public int arenaJumpingTime = 0;
    public int arenaJumpingTimeMax = 60;
    protected double jumpHeight = 6.0;

    public EntityAsmodeus(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEAD;
        this.defense = 2;
        this.experience = 1000;
        this.hasAttackSound = false;
        this.justAttackedTime = (short)30;
        this.hasJumpSound = true;
        this.setWidth = 20.0f;
        this.setHeight = 21.0f;
        this.solidCollision = true;
        this.field_70144_Y = 1.0f;
        this.setupMob();
        this.hitAreaWidthScale = 2.0f;
        this.boss = true;
        this.damageMax = 25;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.aiRangedAttack = new EntityAIAttackRanged(this).setSpeed(1.0).setRate(5).setStaminaTime(200).setStaminaDrainRate(3).setRange(90.0f).setChaseTime(0).setCheckSight(false);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiRangedAttack);
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpClasses(EntityTrite.class));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpClasses(EntityAstaroth.class));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpClasses(EntityCacodemon.class));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpClasses(EntityNetherSoul.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANIMATION_STATES, (Object)0);
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 5000.0);
        baseAttributes.put("movementSpeed", 0.32);
        baseAttributes.put("knockbackResistance", 1.0);
        baseAttributes.put("followRange", 100.0);
        baseAttributes.put("attackDamage", 18.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151137_ax), 1.0f).setMinAmount(20).setMaxAmount(50));
        this.drops.add(new DropRate(new ItemStack(Items.field_151042_j), 1.0f).setMinAmount(20).setMaxAmount(50));
        this.drops.add(new DropRate(new ItemStack(Items.field_151043_k), 1.0f).setMinAmount(10).setMaxAmount(20));
        this.drops.add(new DropRate(new ItemStack(Items.field_151045_i), 1.0f).setMinAmount(10).setMaxAmount(20));
        this.drops.add(new DropRate(new ItemStack(Items.field_151156_bN), 1.0f).setMinAmount(1).setMaxAmount(8));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("devilstarcharge")), 1.0f).setMinAmount(10).setMaxAmount(50));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("demoniclightningcharge")), 1.0f).setMinAmount(10).setMaxAmount(50));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("soulstonedemonic")), 1.0f).setMinAmount(1).setMaxAmount(3));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getBlock("demonstone")), 1.0f).setMinAmount(64).setMaxAmount(128));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getBlock("demonstonebrick")), 1.0f).setMinAmount(64).setMaxAmount(128));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getBlock("demonstonetile")), 1.0f).setMinAmount(64).setMaxAmount(128));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getBlock("demoncrystal")), 1.0f).setMinAmount(64).setMaxAmount(128));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("nethersoulsigil")), 1.0f).setMinAmount(1).setMaxAmount(3));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72314_b(10.0, 50.0, 10.0).func_72317_d(0.0, 25.0, 0.0);
    }

    @Override
    public boolean isPersistant() {
        if (this.getMasterTarget() != null && this.getMasterTarget() instanceof EntityAsmodeus) {
            return true;
        }
        return super.isPersistant();
    }

    @Override
    public void setArenaCenter(BlockPos pos) {
        super.setArenaCenter(pos);
        this.arenaNodeNetwork = new ArenaNodeNetworkGrid(this.func_130014_f_(), pos, 3, 1, 3, 60);
        this.currentArenaNode = this.arenaNodeNetwork.getClosestNode(this.func_180425_c());
    }

    @Override
    public void func_70636_d() {
        if (this.healthLastTick < 0.0f) {
            this.healthLastTick = this.func_110143_aJ();
        }
        if (this.healthLastTick - this.func_110143_aJ() > 50.0f) {
            this.func_70606_j(this.healthLastTick);
        }
        this.healthLastTick = this.func_110143_aJ();
        if (!this.func_130014_f_().field_72995_K && this.updateTick % 20L == 0L) {
            this.damageTakenThisSec = 0.0f;
        }
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.updateTick % 200L == 0L || !this.firstPlayerTargetCheck) {
                this.firstPlayerTargetCheck = true;
                this.playerTargets = this.getNearbyEntities(EntityPlayer.class, null, 64.0);
            }
            if (this.updateTick % 20L == 0L && this.playerTargets.isEmpty()) {
                this.func_70691_i(50.0f);
            }
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.updatePhases();
            this.updateCurrentArenaNode();
            this.updateArenaMovement();
        }
        if (!this.func_130014_f_().field_72995_K && this.updateTick % 20L == 0L) {
            for (EntityPlayer target : this.playerTargets) {
                if (target.field_71075_bZ.field_75098_d || target.func_175149_v() || !(target.field_70163_u > this.field_70163_u + MobInfo.bossAntiFlight)) continue;
                for (int i = 0; i < 3; ++i) {
                    EntityNetherSoul entityNetherSoul = new EntityNetherSoul(this.func_130014_f_());
                    this.summonMinion((EntityLivingBase)entityNetherSoul, this.func_70681_au().nextDouble() * 360.0, 5.0);
                    entityNetherSoul.func_70624_b((EntityLivingBase)target);
                }
            }
        }
        if (this.func_130014_f_().field_72995_K && this.updateTick % 200L == 0L) {
            if (!this.triteMinions.isEmpty()) {
                for (EntityCreatureBase entityCreatureBase : this.triteMinions.toArray(new EntityTrite[this.triteMinions.size()])) {
                    if (entityCreatureBase != null && entityCreatureBase.func_70089_S() && entityCreatureBase.getMasterTarget() == this) continue;
                    this.triteMinions.remove((Object)entityCreatureBase);
                }
            }
            if (!this.astarothMinions.isEmpty()) {
                for (EntityCreatureBase entityCreatureBase : this.astarothMinions.toArray(new EntityAstaroth[this.astarothMinions.size()])) {
                    if (entityCreatureBase != null && entityCreatureBase.func_70089_S() && entityCreatureBase.getMasterTarget() == this) continue;
                    this.astarothMinions.remove((Object)entityCreatureBase);
                }
            }
            if (!this.cacodemonMinions.isEmpty()) {
                for (EntityCreatureBase entityCreatureBase : this.cacodemonMinions.toArray(new EntityCacodemon[this.cacodemonMinions.size()])) {
                    if (entityCreatureBase != null && entityCreatureBase.func_70089_S() && entityCreatureBase.getMasterTarget() == this) continue;
                    this.cacodemonMinions.remove((Object)entityCreatureBase);
                }
            }
        }
        if (!this.func_130014_f_().field_72995_K) {
            byte animationState = 0;
            if (this.aiRangedAttack != null && this.aiRangedAttack.attackOnCooldown) {
                animationState = (byte)(animationState + ANIMATION_STATES_ID.COOLDOWN.id);
            }
            this.field_70180_af.func_187227_b(ANIMATION_STATES, (Object)animationState);
        }
        if (this.func_130014_f_().field_72995_K && ((Byte)this.field_70180_af.func_187225_a(ANIMATION_STATES) & ANIMATION_STATES_ID.COOLDOWN.id) > 0) {
            BlockPos particlePos = this.getFacingPosition((Entity)this, 13.0, this.func_70079_am() - this.field_70177_z);
            for (int i = 0; i < 4; ++i) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)particlePos.func_177958_n() + (this.field_70146_Z.nextDouble() - 0.5) * 2.0, (double)particlePos.func_177956_o() + (double)this.field_70131_O * 0.2 + this.field_70146_Z.nextDouble() * 2.0, (double)particlePos.func_177952_p() + (this.field_70146_Z.nextDouble() - 0.5) * 2.0, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public void updateCurrentArenaNode() {
        if (!this.hasArenaCenter()) {
            return;
        }
        if (this.arenaNodeChangeCooldown > 0) {
            --this.arenaNodeChangeCooldown;
            return;
        }
        if (this.func_70638_az() == null || !this.func_70638_az().func_70089_S()) {
            this.setCurrentArenaNode(this.arenaNodeNetwork.centralNode);
            return;
        }
        if (this.currentArenaNode != null) {
            this.setCurrentArenaNode(this.currentArenaNode.getClosestAdjacentNode(this.func_70638_az().func_180425_c()));
        } else {
            this.setCurrentArenaNode(this.arenaNodeNetwork.getClosestNode(this.func_70638_az().func_180425_c()));
        }
    }

    public void setCurrentArenaNode(ArenaNode arenaNode) {
        this.arenaNodeChangeCooldown = this.arenaNodeChangeCooldownMax;
        if (this.currentArenaNode == arenaNode) {
            return;
        }
        this.currentArenaNode = arenaNode;
        if (this.currentArenaNode != null && this.currentArenaNode.pos != null) {
            this.arenaJumpingTime = this.arenaJumpingTimeMax;
            this.leap(200.0f, this.jumpHeight, this.currentArenaNode.pos);
            if (this.hasJumpSound) {
                this.playJumpSound();
            }
        }
    }

    public void updateArenaMovement() {
        this.field_70145_X = false;
        if (this.currentArenaNode == null || this.currentArenaNode.pos == null) {
            return;
        }
        if (this.arenaJumpingTime > 0) {
            --this.arenaJumpingTime;
            if (this.updateTick % 4L == 0L) {
                double dropForce = -0.5;
                boolean bl = this.field_70145_X = this.field_70163_u > (double)(this.currentArenaNode.pos.func_177956_o() + 8);
                if (this.field_70163_u < (double)this.currentArenaNode.pos.func_177956_o()) {
                    this.func_70107_b(this.field_70165_t, this.currentArenaNode.pos.func_177956_o(), this.field_70161_v);
                    dropForce = 0.0;
                }
                this.leap(200.0f, dropForce, this.currentArenaNode.pos);
            }
            if (this.arenaJumpingTime == 0) {
                this.func_180429_a(this.currentArenaNode.pos.func_177977_b(), this.func_130014_f_().func_180495_p(this.currentArenaNode.pos.func_177977_b()).func_177230_c());
            }
            return;
        }
        BlockPos arenaPos = this.currentArenaNode.pos;
        double arenaY = this.field_70163_u;
        if (this.func_130014_f_().func_175623_d(arenaPos)) {
            arenaY = arenaPos.func_177956_o();
        } else if (this.func_130014_f_().func_175623_d(arenaPos.func_177982_a(0, 1, 0))) {
            arenaY = arenaPos.func_177982_a(0, 1, 0).func_177956_o();
        }
        if (this.field_70165_t != (double)arenaPos.func_177958_n() || this.field_70163_u != arenaY || this.field_70161_v != (double)arenaPos.func_177952_p()) {
            this.func_70107_b(arenaPos.func_177958_n(), arenaY, arenaPos.func_177952_p());
        }
    }

    public void updatePhases() {
        int playerCount = Math.max(this.playerTargets.size(), 1);
        if (this.getBattlePhase() == 0) {
            if (this.devilstarStreamTime > 0) {
                --this.devilstarStreamTime;
                if (this.updateTick % 10L == 0L) {
                    for (float angle = 0.0f; angle < 360.0f; angle += 10.0f) {
                        this.attackDevilstar(angle);
                    }
                }
            } else if (this.devilstarStreamCharge > 0) {
                --this.devilstarStreamCharge;
            } else {
                this.devilstarStreamCharge = this.devilstarStreamChargeMax;
                this.devilstarStreamTime = this.devilstarStreamTimeMax;
            }
            if (this.triteMinions.size() < playerCount * 3 && this.updateTick % 10L * 20L == 0L) {
                for (int i = 0; i < 3 * playerCount; ++i) {
                    EntityTrite minion = new EntityTrite(this.func_130014_f_());
                    this.summonMinion((EntityLivingBase)minion, this.func_70681_au().nextDouble() * 360.0, 10.0);
                    this.triteMinions.add(minion);
                }
            }
        } else if (this.getBattlePhase() == 1 && this.updateTick % 20L == 0L) {
            if (this.astarothMinions.isEmpty() && this.hellshieldAstarothRespawnTime-- <= 0) {
                for (int i = 0; i < 2 * playerCount; ++i) {
                    EntityAstaroth minion = new EntityAstaroth(this.func_130014_f_());
                    this.summonMinion((EntityLivingBase)minion, this.func_70681_au().nextDouble() * 360.0, 0.0);
                    minion.setSizeScale(2.5);
                    this.astarothMinions.add(minion);
                }
                this.hellshieldAstarothRespawnTime = this.hellshieldAstarothRespawnTimeMax;
            }
        } else if (this.updateTick % 20L == 0L) {
            EntityCreatureBase minion;
            int i;
            if (this.astarothMinions.size() < playerCount * 4 && this.rebuildAstarothRespawnTime-- <= 0) {
                for (i = 0; i < playerCount; ++i) {
                    minion = new EntityAstaroth(this.func_130014_f_());
                    this.summonMinion((EntityLivingBase)minion, this.func_70681_au().nextDouble() * 360.0, 0.0);
                    minion.setSizeScale(2.5);
                    this.astarothMinions.add((EntityAstaroth)minion);
                }
                this.rebuildAstarothRespawnTime = this.rebuildAstarothRespawnTimeMax;
            }
            if (this.cacodemonMinions.size() < playerCount * 6 && this.updateTick % 10L * 20L == 0L) {
                for (i = 0; i < 5 * playerCount; ++i) {
                    minion = new EntityCacodemon(this.func_130014_f_());
                    this.summonMinion((EntityLivingBase)minion, this.func_70681_au().nextDouble() * 360.0, 10.0);
                    ((EntityCacodemon)minion).field_70163_u += (double)(10 + this.func_70681_au().nextInt(20));
                    this.cacodemonMinions.add((EntityCacodemon)minion);
                }
            }
            if (!this.astarothMinions.isEmpty()) {
                float healAmount = this.astarothMinions.size();
                if ((double)((this.func_110143_aJ() + healAmount) / this.func_110138_aP()) <= 0.2) {
                    this.func_70691_i(healAmount * 2.0f);
                }
            }
        }
    }

    @Override
    public void updateBattlePhase() {
        double healthNormal = this.func_110143_aJ() / this.func_110138_aP();
        if (healthNormal <= 0.2) {
            this.setBattlePhase(2);
            return;
        }
        if (healthNormal <= 0.6) {
            this.setBattlePhase(1);
            return;
        }
        this.setBattlePhase(0);
    }

    @Override
    public boolean func_70686_a(Class targetClass) {
        if (targetClass.isAssignableFrom(EntityTrite.class) || targetClass.isAssignableFrom(EntityCacodemon.class) || targetClass.isAssignableFrom(EntityAstaroth.class)) {
            return false;
        }
        return super.func_70686_a(targetClass);
    }

    @Override
    public void rangedAttack(Entity target, float range) {
        EntityDevilGatling projectile = new EntityDevilGatling(this.func_130014_f_(), (EntityLivingBase)this);
        projectile.setProjectileScale(4.0f);
        BlockPos offset = this.getFacingPosition((Entity)this, 13.0, this.func_70079_am() - this.field_70177_z);
        projectile.field_70165_t = offset.func_177958_n();
        projectile.field_70163_u = (double)offset.func_177956_o() + (double)this.field_70131_O * 0.2;
        projectile.field_70161_v = offset.func_177952_p();
        double d0 = target.field_70165_t - projectile.field_70165_t;
        double d1 = target.field_70163_u - (double)target.field_70131_O * 0.25 - projectile.field_70163_u;
        double d2 = target.field_70161_v - projectile.field_70161_v;
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.1f;
        float velocity = 1.2f;
        projectile.func_70186_c(d0, d1 + (double)f1, d2, velocity, 0.0f);
        this.func_184185_a(((EntityProjectileBase)projectile).getLaunchSound(), this.func_70599_aP(), 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.func_130014_f_().func_72838_d((Entity)projectile);
        super.rangedAttack(target, range);
    }

    public void attackDevilstar(float angle) {
        EntityDevilstar projectile = new EntityDevilstar(this.func_130014_f_(), (EntityLivingBase)this);
        projectile.setProjectileScale(4.0f);
        BlockPos offset = this.getFacingPosition((Entity)this, 8.0, angle);
        projectile.field_70165_t = offset.func_177958_n();
        projectile.field_70163_u = (double)offset.func_177956_o() + (double)this.field_70131_O * 0.5;
        projectile.field_70161_v = offset.func_177952_p();
        float range = 20.0f + 20.0f * this.func_70681_au().nextFloat();
        BlockPos target = this.getFacingPosition((Entity)this, range, angle);
        double d0 = (double)target.func_177958_n() - projectile.field_70165_t;
        double d1 = (double)target.func_177956_o() - projectile.field_70163_u;
        double d2 = (double)target.func_177952_p() - projectile.field_70161_v;
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.1f;
        float velocity = 1.2f;
        projectile.func_70186_c(d0, d1 + (double)f1, d2, velocity, 0.0f);
        this.func_184185_a(((EntityProjectileBase)projectile).getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.func_130014_f_().func_72838_d((Entity)projectile);
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        if (!this.func_130014_f_().field_72995_K && MobInfo.getFromName((String)"trite").mobEnabled) {
            int j = 6 + this.field_70146_Z.nextInt(20) + this.func_130014_f_().func_175659_aa().func_151525_a() * 4;
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * this.field_70130_N / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * this.field_70130_N / 4.0f;
                EntityTrite trite = new EntityTrite(this.func_130014_f_());
                trite.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                trite.setMinion(true);
                trite.setSubspecies(this.getSubspeciesIndex(), true);
                this.func_130014_f_().func_72838_d((Entity)trite);
                if (this.func_70638_az() == null) continue;
                trite.func_70604_c(this.func_70638_az());
            }
        }
        super.func_70645_a(damageSource);
    }

    @Override
    public void onMinionDeath(EntityLivingBase minion) {
        if (minion instanceof EntityTrite && this.triteMinions.contains(minion)) {
            this.triteMinions.remove(minion);
        }
        if (minion instanceof EntityAstaroth && this.astarothMinions.contains(minion)) {
            this.astarothMinions.remove(minion);
        }
        if (minion instanceof EntityCacodemon && this.cacodemonMinions.contains(minion)) {
            this.cacodemonMinions.remove(minion);
        }
    }

    @Override
    public boolean func_180431_b(DamageSource source) {
        if (this.isBlocking()) {
            return true;
        }
        return super.func_180431_b(source);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_82731_v) {
            return false;
        }
        super.func_70687_e(potionEffect);
        return true;
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean isBlocking() {
        if (this.func_130014_f_().field_72995_K) {
            return super.isBlocking();
        }
        return this.getBattlePhase() == 1 && !this.astarothMinions.isEmpty();
    }

    @Override
    public boolean canAttackWhileBlocking() {
        return true;
    }

    @Override
    public boolean isDamageEntityApplicable(Entity entity) {
        if (entity instanceof EntityPigZombie) {
            entity.func_70106_y();
            return false;
        }
        if (entity instanceof EntityIronGolem) {
            entity.func_70106_y();
            return false;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!player.field_71075_bZ.field_75098_d && player.field_70163_u > this.field_70163_u + MobInfo.bossAntiFlight) {
                return false;
            }
        }
        return super.isDamageEntityApplicable(entity);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSrc, float damage) {
        if (this.playerTargets != null && damageSrc.func_76346_g() != null && damageSrc.func_76346_g() instanceof EntityPlayer && !this.playerTargets.contains(damageSrc.func_76346_g())) {
            this.playerTargets.add((EntityPlayer)damageSrc.func_76346_g());
        }
        return super.func_70097_a(damageSrc, damage);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("DevilstarStreamCharge")) {
            this.devilstarStreamCharge = nbtTagCompound.func_74762_e("DevilstarStreamCharge");
        }
        if (nbtTagCompound.func_74764_b("DevilstarStreamTime")) {
            this.devilstarStreamTime = nbtTagCompound.func_74762_e("DevilstarStreamTime");
        }
        if (nbtTagCompound.func_74764_b("AstarothIDs")) {
            NBTTagList astarothIDs = nbtTagCompound.func_150295_c("AstarothIDs", 10);
            for (int i = 0; i < astarothIDs.func_74745_c(); ++i) {
                Entity entity;
                NBTTagCompound astarothID = astarothIDs.func_150305_b(i);
                if (!astarothID.func_74764_b("ID") || (entity = this.func_130014_f_().func_73045_a(astarothID.func_74762_e("ID"))) == null || !(entity instanceof EntityAstaroth)) continue;
                this.astarothMinions.add((EntityAstaroth)entity);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("DevilstarStreamCharge", this.devilstarStreamCharge);
        nbtTagCompound.func_74768_a("DevilstarStreamTime", this.devilstarStreamTime);
        if (this.getBattlePhase() > 0) {
            NBTTagList astarothIDs = new NBTTagList();
            for (EntityAstaroth entityAstaroth : this.astarothMinions) {
                NBTTagCompound astarothID = new NBTTagCompound();
                astarothID.func_74768_a("ID", entityAstaroth.func_145782_y());
                astarothIDs.func_74742_a((NBTBase)astarothID);
            }
            nbtTagCompound.func_74782_a("AstarothIDs", (NBTBase)astarothIDs);
        }
    }

    public float func_70013_c(float par1) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return 0xF000F0;
    }

    public static enum ANIMATION_STATES_ID {
        SNAP_TO_ARENA(1),
        COOLDOWN(2);

        public final byte id;

        private ANIMATION_STATES_ID(byte value) {
            this.id = value;
        }

        public byte getValue() {
            return this.id;
        }
    }
}

